/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_DEC_DI
implements Instruction {
    private CPU cpu;
    private byte[] oldDest;
    private byte[] decWord;
    private byte[] temp;

    public Instruction_DEC_DI() {
    }

    public Instruction_DEC_DI(CPU cPU) {
        this.cpu = cPU;
        this.oldDest = new byte[2];
        this.temp = new byte[2];
        this.decWord = new byte[]{0, 1};
    }

    @Override
    public void execute() {
        System.arraycopy(this.cpu.di, 0, this.oldDest, 0, this.cpu.di.length);
        this.temp = Util.subtractWords(this.cpu.di, this.decWord, 0);
        System.arraycopy(this.temp, 0, this.cpu.di, 0, this.temp.length);
        this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest[1], this.cpu.di[1]);
        this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.decWord, this.cpu.di, 0);
        this.cpu.flags[6] = this.cpu.di[0] == 0 && this.cpu.di[1] == 0;
        this.cpu.flags[7] = this.cpu.di[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.cpu.di[1]);
    }
}

